export interface Product {
  id: string;
  name: string;
  price: number;
  image: string;
  category: string;
}

export interface VideoCourse {
  id: string;
  title: string;
  duration: string;
  thumbnail: string;
  category: 'Health' | 'Digital' | 'Fraud';
}

export interface HealthData {
  date: string;
  systolic: number;
  diastolic: number;
  heartRate: number;
}

export interface BusSchedule {
  id: string;
  route: string;
  time: string;
  status: 'On Time' | 'Delayed' | 'Arrived';
}

export enum PageRoute {
  HOME = '/',
  LEARNING = '/learning',
  SHOPPING = '/shopping',
  HEALTH = '/health',
  TRANSPORT = '/transport',
  PRESCRIPTION = '/prescription',
}

export interface ChatMessage {
  id: string;
  role: 'user' | 'model';
  text: string;
  isError?: boolean;
}