import React, { useState } from 'react';
import { Layout } from '../components/Layout';
import { Camera, Upload, CheckCircle } from 'lucide-react';

export const Prescription: React.FC = () => {
  const [isUploaded, setIsUploaded] = useState(false);

  const handleUpload = () => {
    // Mock upload process
    setTimeout(() => {
      setIsUploaded(true);
    }, 1000);
  };

  return (
    <Layout title="慢籤服務">
      <div className="space-y-6">
        
        {/* Intro */}
        <div className="text-center py-4">
          <p className="text-lg text-gray-600">您的慢性病連續處方籤快用完了嗎？</p>
          <p className="text-gray-500 text-sm mt-1">拍照上傳，志工幫您代領送到家。</p>
        </div>

        {/* Upload Area */}
        {!isUploaded ? (
          <div className="border-2 border-dashed border-primary/50 rounded-2xl p-8 flex flex-col items-center justify-center bg-teal-50 gap-4">
             <div className="w-20 h-20 bg-white rounded-full flex items-center justify-center shadow-sm text-primary">
               <Camera size={40} />
             </div>
             <div className="text-center">
               <label htmlFor="file-upload" className="cursor-pointer">
                 <span className="block text-xl font-bold text-primary mb-2">拍攝處方籤</span>
                 <span className="text-sm text-gray-500">或從相簿選擇照片</span>
               </label>
               <input 
                  id="file-upload" 
                  type="file" 
                  className="hidden" 
                  accept="image/*"
                  onChange={handleUpload}
               />
             </div>
          </div>
        ) : (
          <div className="bg-green-100 rounded-2xl p-8 flex flex-col items-center justify-center text-green-800 animate-pulse">
            <CheckCircle size={60} className="mb-4" />
            <h3 className="text-2xl font-bold">上傳成功！</h3>
            <p className="mt-2">志工已收到通知，將盡快為您服務。</p>
            <button 
              onClick={() => setIsUploaded(false)}
              className="mt-6 text-sm underline opacity-70"
            >
              重新上傳
            </button>
          </div>
        )}

        {/* History */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
          <h3 className="font-bold text-lg mb-3">領藥紀錄</h3>
          <div className="space-y-3">
             <div className="flex justify-between items-center py-2 border-b border-gray-100">
                <div>
                   <div className="font-bold">頭屋衛生所</div>
                   <div className="text-xs text-gray-500">2023/10/15</div>
                </div>
                <span className="px-2 py-1 bg-gray-100 text-gray-600 text-xs rounded">已完成</span>
             </div>
             <div className="flex justify-between items-center py-2 border-b border-gray-100">
                <div>
                   <div className="font-bold">大千醫院</div>
                   <div className="text-xs text-gray-500">2023/09/12</div>
                </div>
                <span className="px-2 py-1 bg-gray-100 text-gray-600 text-xs rounded">已完成</span>
             </div>
          </div>
        </div>

      </div>
    </Layout>
  );
};
