# 🧪 測試發起共餐功能

## ✅ 修復內容

**主要問題：**
- 變數命名衝突：`selectedRestaurants` 同時用作 DOM 元素和陣列
- 第4步勾選框沒有事件監聽器
- 按鈕狀態驗證邏輯不完整

**修復項目：**
- ✅ 將陣列變數改名為 `selectedRestaurantIds`
- ✅ 為第4步勾選框添加事件監聽器
- ✅ 改進按鈕狀態驗證和視覺反饋
- ✅ 添加調試信息

---

## 🧪 測試步驟

### 步驟1：開啟發起共餐頁面
1. 從 GO食頁面點擊「發起共餐」
2. 或直接開啟 `start-meal.html`

### 步驟2：測試模式選擇
1. **點擊「單店聚餐」**
   - ✅ 應該出現選中狀態（邊框變色）
   - ✅ 「下一步」按鈕應該變為可用（不再灰色）

2. **點擊「多店投票」**
   - ✅ 應該出現選中狀態
   - ✅ 「下一步」按鈕應該變為可用

### 步驟3：測試餐廳選擇
1. **單店模式**
   - ✅ 只能選擇 1 家餐廳
   - ✅ 選擇後「下一步」按鈕可用

2. **多店模式**
   - ✅ 至少需要選擇 2 家餐廳
   - ✅ 最多可以選擇 5 家餐廳
   - ✅ 選擇足夠餐廳後「下一步」按鈕可用

### 步驟4：測試活動設定
1. **必填欄位**
   - ✅ 活動名稱、日期、時間、地點都需填寫
   - ✅ 多店模式需要設定投票截止時間
   - ✅ 所有必填欄位完成後「下一步」可用

### 步驟5：測試最終確認（重點）
1. **勾選框功能**
   - ✅ 初始狀態：「發起活動」按鈕應該是灰色的
   - ✅ 勾選「我同意並遵守社區共餐活動規則」
   - ✅ 勾選後：「發起活動」按鈕應該立即變為可用（藍綠色）
   - ✅ 取消勾選：按鈕應該再次變灰

2. **按鈕狀態**
   - ✅ 可用狀態：按鈕有顏色，cursor 是 pointer
   - ✅ 禁用狀態：按鈕半透明，cursor 是 not-allowed

---

## 🔍 調試信息

打開瀏覽器開發者工具（F12）-> Console 標籤

**應該看到的調試信息：**
```javascript
// 第4步進入時
第4步驗證: { element: true, checked: false, isValid: false }
按鈕狀態更新: { step: 4, isValid: false, disabled: true }

// 勾選框變更時
勾選框狀態變更: true
第4步驗證: { element: true, checked: true, isValid: true }
按鈕狀態更新: { step: 4, isValid: true, disabled: false }
```

---

## 🚨 如果仍有問題

**問題排查：**

1. **刷新頁面**
   - 按 `Ctrl + F5` 強制刷新
   - 清除瀏覽器快取

2. **檢查控制台錯誤**
   - 按 `F12` 打開開發者工具
   - 查看 Console 是否有紅色錯誤信息

3. **手動測試勾選框**
   - 在 Console 中輸入：
   ```javascript
   document.getElementById('agreeTerms').checked = true;
   validateCurrentStep();
   ```

4. **檢查按鈕元素**
   - 在 Console 中輸入：
   ```javascript
   console.log('按鈕狀態:', {
       disabled: document.getElementById('nextBtn').disabled,
       opacity: document.getElementById('nextBtn').style.opacity
   });
   ```

---

## 🎯 預期結果

**成功標準：**
- ✅ 所有4個步驟都能正常進行
- ✅ 第4步勾選框響應正常
- ✅ 按鈕狀態實時更新
- ✅ 最終能成功發起活動
- ✅ 顯示成功對話框和邀請連結

---

**如果測試成功，您將看到：**
1. 🎉 成功對話框
2. 📱 生成的邀請連結
3. 🔗 可以前往管理活動或查看活動列表

請按照以上步驟測試，如果還有問題請告訴我具體在哪一步出錯！
