# 🖼️ 如何更換餐廳圖片

## 📋 目前狀態

目前GO食頁面使用臨時的 **Placeholder 圖片**（透過 Lorem Picsum 服務），讓您可以立即看到網站效果。

## 🔄 兩種更換圖片的方式

### 方式一：使用本地圖片（推薦）

1. **準備圖片**
   - 根據 `圖片清單.md` 中的指南收集圖片
   - 將圖片放入 `images/restaurants/` 資料夾
   - 確保檔名正確（如：`xiaolongbao-1.jpg`）

2. **修改代碼**
   打開 `gofood-script.js`，找到以下區域並替換：

   ```javascript
   // 目前使用的臨時圖片
   photos: ['https://picsum.photos/800/600?random=1&sig=xiaolongbao1', 
            'https://picsum.photos/800/600?random=2&sig=xiaolongbao2'],
   
   // 替換為本地圖片
   photos: ['images/restaurants/xiaolongbao-1.jpg', 
            'images/restaurants/xiaolongbao-2.jpg'],
   ```

3. **完整替換清單**
   
   **金華小籠包:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=1&sig=xiaolongbao1', 
            'https://picsum.photos/800/600?random=2&sig=xiaolongbao2'],
   // 改為:
   photos: ['images/restaurants/xiaolongbao-1.jpg', 
            'images/restaurants/xiaolongbao-2.jpg'],
   ```

   **阿嬤的味道:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=3&sig=grandma1', 
            'https://picsum.photos/800/600?random=4&sig=grandma2'],
   // 改為:
   photos: ['images/restaurants/grandma-food-1.jpg', 
            'images/restaurants/grandma-food-2.jpg'],
   ```

   **日式拉麵屋:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=5&sig=ramen1', 
            'https://picsum.photos/800/600?random=6&sig=ramen2'],
   // 改為:
   photos: ['images/restaurants/ramen-1.jpg', 
            'images/restaurants/ramen-2.jpg'],
   ```

   **老王牛肉麵:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=7&sig=beef1', 
            'https://picsum.photos/800/600?random=8&sig=beef2'],
   // 改為:
   photos: ['images/restaurants/beef-noodles-1.jpg', 
            'images/restaurants/beef-noodles-2.jpg'],
   ```

   **素食天堂:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=9&sig=veg1', 
            'https://picsum.photos/800/600?random=10&sig=veg2'],
   // 改為:
   photos: ['images/restaurants/vegetarian-1.jpg', 
            'images/restaurants/vegetarian-2.jpg'],
   ```

   **海鮮大排檔:**
   ```javascript
   // 從:
   photos: ['https://picsum.photos/800/600?random=11&sig=seafood1', 
            'https://picsum.photos/800/600?random=12&sig=seafood2'],
   // 改為:
   photos: ['images/restaurants/seafood-1.jpg', 
            'images/restaurants/seafood-2.jpg'],
   ```

### 方式二：使用其他線上圖片服務

如果您找到適合的線上圖片，也可以直接替換 URL：

```javascript
photos: ['https://example.com/your-image-1.jpg', 
         'https://example.com/your-image-2.jpg'],
```

## 🧪 測試步驟

更換圖片後：

1. **清除瀏覽器快取**
   - Windows: `Ctrl + F5`
   - Mac: `Cmd + Shift + R`

2. **檢查圖片載入**
   - 開啟 GO食頁面
   - 確認每家餐廳的圖片正常顯示
   - 測試圖片輪播功能

3. **檢查控制台**
   - 按 `F12` 開啟開發者工具
   - 查看是否有圖片載入錯誤

## 📱 裝置測試

建議在不同裝置上測試：
- 手機瀏覽器
- 平板瀏覽器  
- 桌面瀏覽器

## ⚠️ 注意事項

1. **檔案大小**: 建議每張圖片不超過 500KB
2. **網路速度**: 本地圖片載入更快
3. **版權問題**: 確保圖片可以合法使用
4. **備份**: 更改前請備份原始檔案

## 🚀 快速替換腳本

您也可以使用文字編輯器的「尋找並取代」功能快速替換所有圖片路徑：

**尋找:** `https://picsum.photos/800/600?random=1&sig=xiaolongbao1`
**取代:** `images/restaurants/xiaolongbao-1.jpg`

依此類推替換所有12個圖片URL。

---

**完成替換後，您的GO食頁面將展現最佳的視覺效果！** 🎉
